//CD_CashCode.c - deals with picking up and dropping cash + some other things

#include "g_local.h"

cvar_t	*maxcash;
cvar_t	*prop_enable;
char version_check[8];

void CheckMaxCash(edict_t* self)
{
	edict_t *cash;

	if (self->client->pers.currentcash > maxcash->value)
	{
		cash = SpawnTheWeapon( self, "item_cashroll" );
		cash->currentcash = self->client->pers.currentcash - maxcash->value;
		self->client->pers.currentcash = maxcash->value;
		cash->velocity[0] = crandom() * 100;
		cash->velocity[1] = crandom() * 100;
		cash->velocity[2] = 0;
		VectorNormalize( cash->velocity );
		VectorScale( cash->velocity, 100, cash->velocity );
		cash->velocity[2] = 300;
	}
}

void VersionCheck(edict_t *ent)
{
	char buf[32];
//	strcpy(buf,"CDVERCHECK $pver\n");
	sprintf(buf, "%s $pver\n", version_check);
	gi.WriteByte(13);
	gi.WriteString(buf);
	gi.unicast(ent, true);
}

//Used when class_speeds is active to allow players to have different move speeds
void SpeedCheck(edict_t *ent)
{
	int Speed;
	char buf[128];

	if(!class_speeds->value)
		return;
	if((ent->client->resp.class_ptr) && (ent->client->pers.team != 0))
	{
		Speed = (int)(160 * ent->client->resp.class_ptr->speed);
		sprintf(buf, "cl_forwardspeed %i\ncl_sidespeed %i\ncl_upspeed %i\n", Speed, Speed, Speed);
		gi.WriteByte(13);
		gi.WriteString(buf);
		gi.unicast(ent, true);
	}
	ent->client->pers.SpeedCheckTime = 500;//= check every 10 seconds (or thereabouts)
}

void CheckSpeedCheck(edict_t *ent)
{
	if(ent->client->pers.SpeedCheckTime > 0)
	{
		ent->client->pers.SpeedCheckTime--;
		return;
	}
	SpeedCheck(ent);
}

qboolean SpecCheck(void)//Checks if any spectators
{
	edict_t		*cl_ent;
	int i;

	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		if(cl_ent->client->pers.team == 0)
			return true;
	}
	return false;
}

void DisplaySpecs(edict_t* ent)
{
	edict_t		*cl_ent;
	int i, j, y;
	char	entry[1024];
	char	string[1400];
	int		stringlength;
	char NameString[64];
	char header1[] = {"Spectators"};
	char header2[] = {"----------"};
	string[0] = 0;
	stringlength = 0;
	y = -45;
	
	Com_sprintf (entry, sizeof(entry),
		"xm -50 yv -80 dmstr 9cf %s ", header1);
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	Com_sprintf (entry, sizeof(entry),
		"xm -50 yv -68 dmstr 9cf %s ", header2);
	j = strlen(entry);
	strcpy (string + stringlength, entry);
	stringlength += j;

	for (i=0 ; i<game.maxclients ; i++)
	{
		cl_ent = g_edicts + 1 + i;
		if (!cl_ent->inuse)
			continue;
		if(cl_ent->client->pers.team == 0)
		{
//0-((strlen(NameString)*8)/2), 
			strcpy(NameString, cl_ent->client->pers.netname);
			Com_sprintf (entry, sizeof(entry),
				"xm -105 yv %i dmstr aaa \"%s\" xm 85 dmstr 99e %i ", y, NameString, cl_ent->client->ping);
			j = strlen(entry);
			if (stringlength + j > 1024)
				break;
			strcpy (string + stringlength, entry);
			stringlength += j;
			y+=20;
		}
	}
	gi.WriteByte (svc_layout);
	gi.WriteString (string);
	gi.unicast (ent, true);
}

extern void ED_CallSpawn (edict_t *ent);

void PowerLevelHacks(void)
{
//Used to add spawnpoints to incomplete maps
	if (!strcmp( level.mapname, "powerfast" ))
	{
		edict_t *sp;
//Hired thugs
		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 1245, -1193, 174 );
		sp->s.angles[YAW] = 180;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 1144, -1193, 174 );
		sp->s.angles[YAW] = 0;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 239, -1542, 182 );
		sp->s.angles[YAW] = 45;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 242, -1270, 18 );
		sp->s.angles[YAW] = 0;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 1536, -1195, 19 );
		sp->s.angles[YAW] = 90;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 1323, -864, 19 );
		sp->s.angles[YAW] = 315;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 1888, 608, 18 );
		sp->s.angles[YAW] = 225;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 828, 603, 18 );
		sp->s.angles[YAW] = 0;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 908, 605, 18 );
		sp->s.angles[YAW] = 180;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, -170, -823, 19 );
		sp->s.angles[YAW] = 315;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_hired_help" );
		VectorSet( sp->s.origin, 1418, 49, 22 );
		sp->s.angles[YAW] = 90;
		ED_CallSpawn( sp );
//Traders
		sp = G_Spawn();
		sp->classname = G_CopyString( "power_cast_trader" );
		VectorSet( sp->s.origin, 477, -992, 178 );
		sp->s.angles[YAW] = 315;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_cast_trader" );
		VectorSet( sp->s.origin, 1154, -1372, 19 );
		sp->s.angles[YAW] = 0;
		ED_CallSpawn( sp );

		sp = G_Spawn();
		sp->classname = G_CopyString( "power_cast_trader" );
		VectorSet( sp->s.origin, 1261, -469, 28 );
		sp->s.angles[YAW] = 0;
		ED_CallSpawn( sp );
	}
}

